//	TorusGamesOptionsChoiceController.h
//
//	© 2021 by Jeff Weeks
//	See TermsOfUse.txt

#import <UIKit/UIKit.h>
#import "GeometryGamesPopover.h"
#import "TorusGames-Common.h"

@protocol TorusGamesOptionsChoiceDelegate
- (BOOL)prefersStatusBarHidden;
- (void)userDidChooseOptionHumanVsComputer:(bool)aHumanVsComputer;
- (void)userDidChooseOptionTopology:(TopologyType)aTopology;
- (void)userDidChooseOptionDifficultyLevel:(unsigned int)aDifficultyLevel;
- (void)userDidChooseOptionViewType:(ViewType)aViewType;
- (void)userDidChooseOptionSoundEffects:(bool)aSoundEffects;
- (void)userDidCancelOptionsChoice;
@end

@interface TorusGamesOptionsChoiceController : UITableViewController
	<UITableViewDataSource, UITableViewDelegate, GeometryGamesPopover>

- (id)initWithDelegate:(id<TorusGamesOptionsChoiceDelegate>)aDelegate 
	humanVsComputer:(bool)aHumanVsComputer topology:(TopologyType)aTopology
	difficultyLevel:(unsigned int)aDifficultyLevel viewType:(ViewType)aViewType
	soundEffects:(bool)aSoundEffects duringGame:(GameType)aGame;
- (BOOL)prefersStatusBarHidden;
- (void)viewWillAppear:(BOOL)animated;

//	GeometryGamesPopover
- (void)adaptNavBarForHorizontalSize:(UIUserInterfaceSizeClass)aHorizontalSizeClass;

//	UITableViewDataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)aTableView;
- (NSString *)tableView:(UITableView *)aTableView titleForHeaderInSection:(NSInteger)aSection;
- (NSInteger)tableView:(UITableView *)aTableView numberOfRowsInSection:(NSInteger)aSection;
- (UITableViewCell *)tableView:(UITableView *)aTableView cellForRowAtIndexPath:(NSIndexPath *)anIndexPath;

//	UITableViewDelegate
- (NSIndexPath *)tableView:(UITableView *)aTableView willSelectRowAtIndexPath:(NSIndexPath *)anIndexPath;

@end
